/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.ai.goals.AllDirectionsTargetGoal;
import com.alexander.mutantmore.ai.goals.ApproachTargetGoal;
import com.alexander.mutantmore.ai.goals.AvoidTargetGoal;
import com.alexander.mutantmore.ai.goals.LookAtTargetGoal;
import com.alexander.mutantmore.config.MutantBlazeClientConfig;
import com.alexander.mutantmore.config.MutantBlazeCommonConfig;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsClientConfig;
import com.alexander.mutantmore.config.MutantMoreGroupedOptionsCommonConfig;
import com.alexander.mutantmore.entities.MutantBlazeFireball;
import com.alexander.mutantmore.entities.MutantBlazeRodProjectile;
import com.alexander.mutantmore.entities.MutantBlazeShieldPart;
import com.alexander.mutantmore.entities.Rodling;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.MusicInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.SoundEventInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.interfaces.IHasBossMusic;
import com.alexander.mutantmore.interfaces.IHasCustomExplosion;
import com.alexander.mutantmore.interfaces.IHeatSource;
import com.alexander.mutantmore.interfaces.IMutatable;
import com.alexander.mutantmore.interfaces.INaturallySpawningMutant;
import com.alexander.mutantmore.particles.EntityTrackingParticleOption;
import com.alexander.mutantmore.pathfinding.ImprovedMoveControl;
import com.alexander.mutantmore.util.BossMusicUtils;
import com.alexander.mutantmore.util.HandleLoopingSoundInstances;
import com.alexander.mutantmore.util.MiscUtils;
import com.alexander.mutantmore.util.PositionUtils;
import com.google.common.collect.Lists;
import com.mojang.math.Vector3d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.IAnimationTickable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MutantBlaze
extends Monster
implements IAnimatable,
IAnimationTickable,
IMutatable,
INaturallySpawningMutant,
IHasBossMusic,
IHeatSource,
IHasCustomExplosion {
    private static final List<EntityDataAccessor<Boolean>> SHIELDS_BROKEN = Lists.newArrayList((Object[])new EntityDataAccessor[]{SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_), SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_), SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_), SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_), SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_), SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_), SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_)});
    private static final EntityDataAccessor<Integer> TARGETED_ENTITY_ID = SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(MutantBlaze.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_6).m_7003_(true);
    public int introAnimationTick;
    public int introAnimationLength = 25;
    public int noveltyAnimationTick;
    public int noveltyAnimationLength = 80;
    public int shootAnimationTick;
    public int shootAnimationLength = 70;
    public int shootAnimationActionPoint = 30;
    public int rodShotAnimationTick;
    public int rodShotAnimationLength = 105;
    public int rodShotAnimationActionStartPoint = 34;
    public int rodShotAnimationActionEndPoint = 21;
    public int[] shieldRegenerateTicks = new int[]{0, 0, 0, 0, 0, 0, 0};
    public int shieldRegenerateTime = (Integer)MutantBlazeCommonConfig.shield_regenerate_speed.get();
    public int stunnedTicks;
    public int stunnedLength = 203;
    public int stunnedAnimationActionPoint = 20;
    public DamageSource killedBy;
    public static EntityDimensions crouchingDimensions = EntityDimensions.m_20395_((float)1.9f, (float)2.4f);
    public MutantBlazeShieldPart[] subEntities = new MutantBlazeShieldPart[7];
    private static final Predicate<Entity> SHOCKWAVABLE = target -> target.m_6084_();
    private int destroyBlocksTick;

    public MutantBlaze(EntityType<? extends MutantBlaze> p_i50189_1_, Level p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
        this.f_21342_ = new ImprovedMoveControl((Mob)this, 90.0f, 3);
        this.f_21364_ = (Integer)MutantBlazeCommonConfig.exp_reward.get();
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        for (int i = 0; i < 7; ++i) {
            MutantBlazeShieldPart shield;
            this.subEntities[i] = shield = new MutantBlazeShieldPart(this, i);
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RemainStationaryGoal());
        if (((Boolean)MutantBlazeCommonConfig.uses_flight_ability.get()).booleanValue()) {
            this.f_21345_.m_25352_(1, (Goal)new FlyStrafeMovementGoal(this));
        }
        if (((Boolean)MutantBlazeCommonConfig.avoids_target.get()).booleanValue()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidTargetGoal((PathfinderMob)this, (Double)MutantBlazeCommonConfig.avoid_target_max_range.get(), (Double)MutantBlazeCommonConfig.stop_avoiding_target_min_distance.get(), (Double)MutantBlazeCommonConfig.avoid_target_movement_speed_multiplier.get(), false){

                @Override
                public boolean m_8036_() {
                    return super.m_8036_() && !MutantBlaze.this.isFlying();
                }

                @Override
                public boolean m_8045_() {
                    return super.m_8045_() && !MutantBlaze.this.isFlying();
                }
            });
        }
        if (((Boolean)MutantBlazeCommonConfig.avoids_corridors.get()).booleanValue()) {
            this.f_21345_.m_25352_(3, (Goal)new LeaveCorridorsGoal(this, (Double)MutantBlazeCommonConfig.flee_corridors_movement_speed_multiplier.get()));
        }
        if (((Boolean)MutantBlazeCommonConfig.uses_fireball_attack.get()).booleanValue()) {
            this.f_21345_.m_25352_(4, (Goal)new ShootAttackGoal(this));
        }
        if (((Boolean)MutantBlazeCommonConfig.uses_rod_shot_attack.get()).booleanValue()) {
            this.f_21345_.m_25352_(5, (Goal)new RodShotAttackGoal(this));
        }
        this.f_21345_.m_25352_(6, (Goal)new ApproachTargetGoal((PathfinderMob)this, (Double)MutantBlazeCommonConfig.follow_target_wanted_distance.get(), (Double)MutantBlazeCommonConfig.following_movement_speed_multiplier.get(), true));
        this.f_21345_.m_25352_(7, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 10.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26146_(6000));
        if (((Boolean)MutantBlazeCommonConfig.attacks_players.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutants_attack_players_off.get()).booleanValue()) {
            this.f_21346_.m_25352_(1, (Goal)new AllDirectionsTargetGoal<Player>((Mob)this, Player.class, true).m_26146_(6000));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 20, false, false, entity -> entity.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_BLAZE_TARGETS)){

            protected AABB m_7255_(double p_26069_) {
                return this.f_26135_.m_20191_().m_82377_(((Double)MutantBlazeCommonConfig.follow_non_player_distance.get()).doubleValue(), ((Double)MutantBlazeCommonConfig.follow_non_player_distance.get()).doubleValue(), ((Double)MutantBlazeCommonConfig.follow_non_player_distance.get()).doubleValue());
            }
        });
    }

    public boolean m_6779_(LivingEntity target) {
        return this.canTarget((Entity)target) && super.m_6779_(target);
    }

    boolean canTarget(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_BLAZE_CANT_TARGET, (Entity)this, target, (Entity)this, null);
    }

    protected PathNavigation m_6037_(Level p_33348_) {
        return new MutantBlazeNavigation((Mob)this, p_33348_);
    }

    public boolean shouldBeStationary() {
        return this.f_20919_ > 0 || this.introAnimationTick > 0 || this.stunnedTicks > 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 5.0);
    }

    public void setConfigurableAttributeValues() {
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)MutantBlazeCommonConfig.max_health.get()).doubleValue());
        this.m_21051_(Attributes.f_22284_).m_22100_(((Double)MutantBlazeCommonConfig.armour.get()).doubleValue());
        this.m_21051_(Attributes.f_22285_).m_22100_(((Double)MutantBlazeCommonConfig.armour_toughness.get()).doubleValue());
        this.m_21051_(Attributes.f_22278_).m_22100_(((Double)MutantBlazeCommonConfig.knockback_resistance.get()).doubleValue());
        this.m_21051_(Attributes.f_22277_).m_22100_(((Double)MutantBlazeCommonConfig.follow_player_distance.get()).doubleValue());
        this.m_21051_(Attributes.f_22279_).m_22100_(((Double)MutantBlazeCommonConfig.movement_speed.get()).doubleValue());
        this.m_21153_(this.m_21233_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_) {
        this.setConfigurableAttributeValues();
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public float getStepHeight() {
        return 1.6f;
    }

    @Override
    public boolean shouldPlayMusic() {
        if (this.f_19853_.f_46443_) {
            return BossMusicUtils.canMobPlayBossMusic((Mob)this, (Boolean)MutantBlazeClientConfig.play_battle_music.get(), this.getTargetedEntityID());
        }
        return false;
    }

    @Override
    public Music getBossMusic() {
        return MusicInit.MUTANT_THEME_SLOW;
    }

    public void m_6043_() {
        if (!((Boolean)MutantBlazeCommonConfig.despawns.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutant_despawning_on.get()).booleanValue()) {
            if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_8028_()) {
                this.m_146870_();
            } else {
                this.f_20891_ = 0;
            }
        } else {
            super.m_6043_();
        }
    }

    @Override
    public void onMutantSpawned(MobSpawnType spawnReason) {
        this.m_20124_(Pose.CROUCHING);
        if (!this.f_19853_.f_46443_) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)(aabb.f_82289_ + 1.0)), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    @Override
    public void onMutated() {
        this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_INTRO.get(), 2.5f, 1.0f);
        this.m_20124_(Pose.CROUCHING);
        if (!this.f_19853_.f_46443_) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)(aabb.f_82289_ + 1.0)), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                flag = this.f_19853_.m_46953_(blockpos, true, (Entity)this) || flag;
            }
        }
        this.introAnimationTick = this.introAnimationLength;
        this.f_19853_.m_7605_((Entity)this, (byte)11);
        ShakeCameraEvent.shake(this.f_19853_, 80, 0.05f, this.m_20183_(), 25, CameraShakePriority.STRONG_MOB_ACTION);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_death", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.introAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_intro", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.stunnedTicks > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_stunned", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.rodShotAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_rod_shot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.shootAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_6047_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_crouching", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.noveltyAnimationTick > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_novelty", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("mutant_blaze_idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 2.0f, this::predicate));
    }

    public void tickDownAnimTimers() {
        if (this.noveltyAnimationTick > 0) {
            --this.noveltyAnimationTick;
        }
        if (this.introAnimationTick > 0) {
            --this.introAnimationTick;
        }
        if (this.shootAnimationTick > 0) {
            --this.shootAnimationTick;
        }
        if (this.rodShotAnimationTick > 0) {
            --this.rodShotAnimationTick;
        }
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int tickTimer() {
        return this.f_19797_;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundEventInit.MUTANT_BLAZE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundEventInit.MUTANT_BLAZE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public float m_6100_() {
        return this.m_21224_() ? 1.0f : super.m_6100_();
    }

    protected float m_6121_() {
        return this.m_21224_() ? 3.0f : 2.0f;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.f_19853_.f_46443_) {
            HandleLoopingSoundInstances.addMutantBlazeAudio(this, this.f_19853_);
        }
    }

    public void shootMutantBlazeFireball(double xMotion, double yMotion, double zMotion, boolean fromDeath) {
        MutantBlazeFireball fireball = new MutantBlazeFireball(this.f_19853_, (LivingEntity)this, xMotion, yMotion, zMotion);
        fireball.damage = ((Double)MutantBlazeCommonConfig.fireball_damage.get()).floatValue();
        fireball.explosionDamage = ((Double)MutantBlazeCommonConfig.fireball_explosion_damage.get()).floatValue();
        fireball.explosionRadius = ((Double)MutantBlazeCommonConfig.fireball_explosion_radius.get()).floatValue();
        fireball.fireLength = (Integer)MutantBlazeCommonConfig.fireball_set_mob_on_fire_length.get();
        fireball.ignoresInvulTime = (Boolean)MutantBlazeCommonConfig.ignores_invulnerability_time.get();
        fireball.griefing = (Boolean)MutantBlazeCommonConfig.fireball_griefing.get() != false && (Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get() == false;
        fireball.griefingDropsBlocks = (Boolean)MutantBlazeCommonConfig.fireball_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false;
        fireball.explosionFire = (Boolean)MutantBlazeCommonConfig.fireball_explosion_fire.get();
        fireball.m_6034_(fireball.m_20185_(), this.m_20227_(0.5), fireball.m_20189_());
        if (fromDeath) {
            fireball.spawnedByDyingMutantBlaze = true;
        } else {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_SHOOT.get(), 2.0f, this.m_6100_());
        }
        this.f_19853_.m_7967_((Entity)fireball);
    }

    @Override
    public boolean canHarmWithExplosion(Entity target) {
        return this.explosionCanHarm(target);
    }

    boolean explosionCanHarm(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_BLAZE_FIREBALL_CANT_HURT, (Entity)this, target, (Entity)this, null);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (source != null && source == DamageSource.f_19317_) {
            this.m_5496_(SoundEvents.f_12038_, this.m_6121_(), this.m_6100_());
        } else {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_PRE_DEATH.get(), this.m_6121_(), 1.0f);
        }
        this.killedBy = source;
    }

    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        if (!this.m_6673_(p_21016_) && this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        return super.m_6469_(p_21016_, p_21017_);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.m_21225_() != null && this.m_21225_() == DamageSource.f_19317_) {
            if (this.f_20919_ == 20 && !this.f_19853_.m_5776_()) {
                this.f_19853_.m_7605_((Entity)this, (byte)60);
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else {
            if (this.f_20919_ >= 20 && this.f_20919_ < 180) {
                this.m_20334_(0.0, 0.05, 0.0);
            } else if (this.f_20919_ >= 180) {
                this.m_20334_(0.0, 0.0, 0.0);
            }
            if (this.f_20919_ == 180) {
                this.f_19853_.m_7106_((ParticleOptions)new EntityTrackingParticleOption("mutantmore:mutant_blaze_charge_shot", this.m_19879_(), 0.0, 2.5, 0.0), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_FLARE.get(), 3.0f, this.m_6100_());
            }
            if (this.f_20919_ == 200) {
                int i;
                ShakeCameraEvent.shake(this.f_19853_, 100, 0.025f, this.m_20183_(), 25, CameraShakePriority.STRONG_MOB_ACTION);
                this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_DEATH.get(), 3.0f, 1.0f);
                for (i = 0; i < 1000; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), -1.0 + this.f_19796_.m_188500_() * 2.0, -0.5 + this.f_19796_.m_188500_() * 1.0, -1.0 + this.f_19796_.m_188500_() * 2.0);
                }
                for (i = 0; i < 500; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), -1.0 + this.f_19796_.m_188500_() * 2.0, -0.5 + this.f_19796_.m_188500_() * 1.0, -1.0 + this.f_19796_.m_188500_() * 2.0);
                }
                for (i = 0; i < 250; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), -1.0 + this.f_19796_.m_188500_() * 2.0, -0.5 + this.f_19796_.m_188500_() * 1.0, -1.0 + this.f_19796_.m_188500_() * 2.0);
                }
                if (!this.f_19853_.f_46443_) {
                    Vec3 motion;
                    int i2;
                    ArrayList rods = Lists.newArrayList();
                    ArrayList nonRodlingRods = Lists.newArrayList();
                    if (((Boolean)MutantBlazeCommonConfig.explode_into_parts.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mutants_explode_into_parts_off.get()).booleanValue()) {
                        int i3;
                        for (i3 = 0; i3 < (Integer)MutantBlazeCommonConfig.part_amount.get(); ++i3) {
                            rod = new MutantBlazeRodProjectile(this.f_19853_, (LivingEntity)this);
                            rods.add(rod);
                            nonRodlingRods.add(rod);
                        }
                        for (i3 = 0; i3 < (Integer)MutantBlazeCommonConfig.rodling_part_amount.get(); ++i3) {
                            rod = (MutantBlazeRodProjectile)((Object)nonRodlingRods.get(this.f_19796_.m_188503_(nonRodlingRods.size())));
                            rod.setIsRodling(true);
                            nonRodlingRods.remove((Object)rod);
                        }
                        for (MutantBlazeRodProjectile rod : rods) {
                            rod.damage = ((Double)MutantBlazeCommonConfig.part_collision_damage.get()).floatValue();
                            rod.fireLength = (Integer)MutantBlazeCommonConfig.part_set_mob_on_fire_length.get();
                            rod.glows = (Boolean)MutantBlazeCommonConfig.parts_glow.get();
                            rod.despawnTime = (Integer)MutantBlazeCommonConfig.part_persist_length.get();
                            rod.ignoresInvulTime = (Boolean)MutantBlazeCommonConfig.ignores_invulnerability_time.get();
                            rod.setCollectable(true);
                            rod.m_6027_(this.m_20185_(), this.m_20227_(0.6), this.m_20189_());
                            rod.m_6686_(0.0, 0.0, 0.0, 3.0f, 20.0f);
                            this.f_19853_.m_7967_((Entity)rod);
                        }
                    } else {
                        int i4;
                        for (i4 = 0; i4 < (Integer)MutantBlazeCommonConfig.rodling_part_amount.get(); ++i4) {
                            rod = new MutantBlazeRodProjectile(this.f_19853_, (LivingEntity)this);
                            rod.setCollectable(true);
                            rod.m_6027_(this.m_20185_(), this.m_20227_(0.6), this.m_20189_());
                            this.f_19853_.m_7967_((Entity)rod);
                        }
                        if (this.killedBy != null) {
                            for (i4 = 0; i4 < (Integer)MutantBlazeCommonConfig.part_amount.get() - (Integer)MutantBlazeCommonConfig.rodling_part_amount.get(); ++i4) {
                                ResourceLocation resourcelocation = new ResourceLocation("mutantmore", "loot_tables/entities/mutant_blaze_part.json");
                                LootTable loottable = this.f_19853_.m_7654_().m_129898_().m_79217_(resourcelocation);
                                LootContext.Builder lootcontext$builder = this.m_7771_(this.f_20889_ > 0, this.killedBy);
                                LootContext ctx = lootcontext$builder.m_78975_(LootContextParamSets.f_81415_);
                                loottable.m_230922_(ctx).forEach(arg_0 -> ((MutantBlaze)this).m_19983_(arg_0));
                            }
                        }
                    }
                    for (i2 = 0; i2 < 3; ++i2) {
                        motion = PositionUtils.getOffsetMotion(null, 0.5, -1.25, 0.0, 120 * i2);
                        this.shootMutantBlazeFireball(motion.f_82479_, motion.f_82480_, motion.f_82481_, true);
                    }
                    for (i2 = 0; i2 < 10; ++i2) {
                        motion = PositionUtils.getOffsetMotion(null, 1.0, -0.75, 0.0, 36 * i2);
                        this.shootMutantBlazeFireball(motion.f_82479_, motion.f_82480_, motion.f_82481_, true);
                    }
                    for (i2 = 0; i2 < 10; ++i2) {
                        motion = PositionUtils.getOffsetMotion(null, 1.0, 0.0, 0.0, 36 * i2);
                        this.shootMutantBlazeFireball(motion.f_82479_, motion.f_82480_, motion.f_82481_, true);
                    }
                    for (i2 = 0; i2 < 10; ++i2) {
                        motion = PositionUtils.getOffsetMotion(null, 1.0, 0.75, 0.0, 36 * i2);
                        this.shootMutantBlazeFireball(motion.f_82479_, motion.f_82480_, motion.f_82481_, true);
                    }
                    for (i2 = 0; i2 < 3; ++i2) {
                        motion = PositionUtils.getOffsetMotion(null, 0.5, 1.25, 0.0, 120 * i2);
                        this.shootMutantBlazeFireball(motion.f_82479_, motion.f_82480_, motion.f_82481_, true);
                    }
                }
            }
            if (this.f_20919_ == 215) {
                if (!this.f_19853_.m_5776_()) {
                    if (this.killedBy != null) {
                        this.dropAllTickDeathLoot(this.killedBy);
                    }
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
                for (int i = 0; i < 20; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
                }
            }
        }
    }

    protected void m_6668_(DamageSource source) {
    }

    public void dropAllTickDeathLoot(DamageSource source) {
        Entity entity = source.m_7639_();
        int i = ForgeHooks.getLootingLevel((Entity)this, (Entity)entity, (DamageSource)source);
        this.captureDrops(new ArrayList());
        boolean flag = this.f_20889_ > 0;
        this.m_7625_(source, flag);
        this.m_7472_(source, i, flag);
        this.m_5907_();
        this.m_21226_();
        Collection drops = this.captureDrops(null);
        if (!ForgeHooks.onLivingDrops((LivingEntity)this, (DamageSource)source, (Collection)drops, (int)i, (this.f_20889_ > 0 ? 1 : 0) != 0)) {
            drops.forEach(e -> this.f_19853_.m_7967_((Entity)e));
        }
    }

    public ItemEntity m_5552_(ItemStack p_19985_, float p_19986_) {
        if (p_19985_.m_41619_()) {
            return null;
        }
        if (this.f_19853_.f_46443_) {
            return null;
        }
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_() + (double)p_19986_, this.m_20189_(), p_19985_);
        itementity.m_32060_();
        itementity.m_32064_();
        if (this.captureDrops() != null) {
            this.captureDrops().add(itementity);
        } else {
            this.f_19853_.m_7967_((Entity)itementity);
        }
        return itementity;
    }

    protected void m_8097_() {
        super.m_8097_();
        for (EntityDataAccessor<Boolean> SHIELD_BROKEN : SHIELDS_BROKEN) {
            this.f_19804_.m_135372_(SHIELD_BROKEN, (Object)false);
        }
        this.f_19804_.m_135372_(TARGETED_ENTITY_ID, (Object)0);
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public int getTargetedEntityID() {
        return (Integer)this.f_19804_.m_135370_(TARGETED_ENTITY_ID);
    }

    public void setTargetedEntityID(int setTo) {
        this.f_19804_.m_135381_(TARGETED_ENTITY_ID, (Object)setTo);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean setTo) {
        this.f_19804_.m_135381_(FLYING, (Object)setTo);
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        for (MutantBlazeShieldPart part : this.subEntities) {
            this.setShieldBroken(part.partNumber, p_70037_1_.m_128471_("Shield" + part.partNumber + "Broken"));
        }
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        for (MutantBlazeShieldPart part : this.subEntities) {
            p_213281_1_.m_128379_("Shield" + part.partNumber + "Broken", this.isShieldBroken(part.partNumber));
        }
    }

    public boolean isShieldBroken(int shieldIndex) {
        return (Boolean)this.f_19804_.m_135370_(SHIELDS_BROKEN.get(shieldIndex));
    }

    public void setShieldBroken(int shieldIndex, boolean broken) {
        if (broken) {
            this.m_216990_((SoundEvent)SoundEventInit.MUTANT_BLAZE_SHIELDBREAK.get());
            this.shieldRegenerateTicks[shieldIndex] = this.shieldRegenerateTime;
        }
        this.f_19804_.m_135381_(SHIELDS_BROKEN.get(shieldIndex), (Object)broken);
    }

    public boolean m_6126_() {
        return true;
    }

    protected void updateParts() {
        for (MutantBlazeShieldPart part : this.subEntities) {
            if (!this.f_19853_.f_46443_ && !this.shieldsInactive()) {
                if (this.shieldRegenerateTicks[part.partNumber] > 0) {
                    int n = part.partNumber;
                    this.shieldRegenerateTicks[n] = this.shieldRegenerateTicks[n] - 1;
                }
                if (this.shieldRegenerateTicks[part.partNumber] == 20) {
                    this.m_216990_((SoundEvent)SoundEventInit.MUTANT_BLAZE_RESHIELD.get());
                }
                if (this.shieldRegenerateTicks[part.partNumber] == 0 && this.isShieldBroken(part.partNumber)) {
                    if (this.stunnedTicks <= 0) {
                        for (int i = 0; i < 3; ++i) {
                            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypeInit.MUTANT_BLAZE_HEAL.get()), part.m_20208_(0.75), part.m_20187_(), part.m_20262_(0.75), 1, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                    this.setShieldBroken(part.partNumber, false);
                }
            }
            part.m_6210_();
            this.positionShield(part);
        }
    }

    protected void movePart(MutantBlazeShieldPart part, double dX, double dY, double dZ) {
        Vector3d lastPos = new Vector3d(part.m_20185_(), part.m_20186_(), part.m_20189_());
        part.m_6034_(this.m_20185_() + dX, this.m_20186_() + dY, this.m_20189_() + dZ);
        part.f_19854_ = lastPos.f_86214_;
        part.f_19855_ = lastPos.f_86215_;
        part.f_19856_ = lastPos.f_86216_;
        part.f_19790_ = lastPos.f_86214_;
        part.f_19791_ = lastPos.f_86215_;
        part.f_19792_ = lastPos.f_86216_;
    }

    protected void positionShield(MutantBlazeShieldPart shield) {
        double upperShieldLayerY = this.m_6047_() ? 0.75 : 2.0;
        double lowerShieldLayerY = 0.25;
        float shieldRotateSpeed = -0.2182f;
        if (shield.partNumber == 0) {
            this.movePart(shield, Mth.m_14089_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(45.0f + this.f_20883_))) * 1.5f, upperShieldLayerY, Mth.m_14031_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(45.0f + this.f_20883_))) * 1.5f);
        } else if (shield.partNumber == 1) {
            this.movePart(shield, Mth.m_14089_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(135.0f + this.f_20883_))) * 1.5f, upperShieldLayerY, Mth.m_14031_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(135.0f + this.f_20883_))) * 1.5f);
        } else if (shield.partNumber == 2) {
            this.movePart(shield, Mth.m_14089_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(225.0f + this.f_20883_))) * 1.5f, upperShieldLayerY, Mth.m_14031_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(225.0f + this.f_20883_))) * 1.5f);
        } else if (shield.partNumber == 3) {
            this.movePart(shield, Mth.m_14089_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(315.0f + this.f_20883_))) * 1.5f, upperShieldLayerY, Mth.m_14031_((float)((float)this.f_19797_ * shieldRotateSpeed + MiscUtils.degToRad(315.0f + this.f_20883_))) * 1.5f);
        } else if (shield.partNumber == 4) {
            this.movePart(shield, (double)Mth.m_14089_((float)((float)this.f_19797_ * -shieldRotateSpeed + MiscUtils.degToRad(-30.0f + this.f_20883_))) * 1.21875, lowerShieldLayerY, (double)Mth.m_14031_((float)((float)this.f_19797_ * -shieldRotateSpeed + MiscUtils.degToRad(-30.0f + this.f_20883_))) * 1.21875);
        } else if (shield.partNumber == 5) {
            this.movePart(shield, (double)Mth.m_14089_((float)((float)this.f_19797_ * -shieldRotateSpeed + MiscUtils.degToRad(90.0f + this.f_20883_))) * 1.21875, lowerShieldLayerY, (double)Mth.m_14031_((float)((float)this.f_19797_ * -shieldRotateSpeed + MiscUtils.degToRad(90.0f + this.f_20883_))) * 1.21875);
        } else if (shield.partNumber == 6) {
            this.movePart(shield, (double)Mth.m_14089_((float)((float)this.f_19797_ * -shieldRotateSpeed + MiscUtils.degToRad(210.0f + this.f_20883_))) * 1.21875, lowerShieldLayerY, (double)Mth.m_14031_((float)((float)this.f_19797_ * -shieldRotateSpeed + MiscUtils.degToRad(210.0f + this.f_20883_))) * 1.21875);
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public boolean shieldsInactive() {
        return this.stunnedTicks > 0 || this.f_20919_ > 0;
    }

    public void m_8107_() {
        this.updateParts();
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (this.f_19853_.f_46443_) {
            if (this.f_19796_.m_188503_(24) == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
        if (this.f_19862_ && ((Boolean)MutantBlazeCommonConfig.walk_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!blockstate.m_204336_(TagInit.Blocks.MUTANT_BLAZE_WALKS_THROUGH)) continue;
                flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantBlazeCommonConfig.walk_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
            }
        }
    }

    public static boolean canBurnBlock(BlockGetter level, Block block, BlockState blockstate, BlockPos blockpos) {
        return !(block instanceof AirBlock) && block.getExplosionResistance(blockstate, level, blockpos, null) <= 6.0f;
    }

    public EntityDimensions m_6972_(Pose p_19975_) {
        return p_19975_ == Pose.CROUCHING ? crouchingDimensions : super.m_6972_(p_19975_);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public boolean shouldCrouchAt(BlockPos pos) {
        boolean markedCrouching = false;
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                markedCrouching = markedCrouching || !this.f_19853_.m_8055_(pos.m_6630_(4).m_122013_(i).m_122030_(j)).m_60795_() || !this.f_19853_.m_8055_(pos.m_6630_(3).m_122013_(i).m_122030_(j)).m_60795_();
            }
        }
        return markedCrouching;
    }

    private void shockwave() {
        if (this.m_6084_()) {
            for (Entity entity : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(((Double)MutantBlazeCommonConfig.stun_shockwave_area.get()).doubleValue()), SHOCKWAVABLE)) {
                if (this.canHurt(entity)) {
                    if (((Boolean)MutantBlazeCommonConfig.ignores_invulnerability_time.get()).booleanValue()) {
                        entity.f_19802_ = 0;
                    }
                    entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), ((Double)MutantBlazeCommonConfig.stun_shockwave_damage.get()).floatValue());
                    entity.m_20254_(((Integer)MutantBlazeCommonConfig.stun_shockwave_set_mob_on_fire_length.get()).intValue());
                    if (entity instanceof LivingEntity) {
                        MiscUtils.disableShield((LivingEntity)entity, (Integer)MutantBlazeCommonConfig.stun_shockwave_disable_shield_length.get());
                    }
                }
                this.strongKnockback(entity);
            }
        }
    }

    boolean canHurt(Entity target) {
        return MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_BLAZE_CANT_HURT, (Entity)this, target, (Entity)this, null);
    }

    private void strongKnockback(Entity p_213688_1_) {
        double d0 = p_213688_1_.m_20185_() - this.m_20185_();
        double d1 = p_213688_1_.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        p_213688_1_.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
    }

    public void m_6075_() {
        BlockPos pos;
        super.m_6075_();
        this.m_6210_();
        this.tickDownAnimTimers();
        if (!this.f_19853_.f_46443_) {
            if (this.m_5448_() != null && !this.m_5448_().m_213877_()) {
                this.setTargetedEntityID(this.m_5448_().m_19879_());
            } else {
                this.setTargetedEntityID(0);
            }
        }
        if (this.stunnedTicks > 0) {
            --this.stunnedTicks;
        }
        if (this.m_5448_() != null && this.stunnedTicks <= this.stunnedLength - 240) {
            this.m_21563_().m_148051_((Entity)this.m_5448_());
        }
        if (this.stunnedTicks == 181) {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_STUN_SHIELDS_BREAK.get(), 1.5f, this.m_6100_());
        }
        if (this.stunnedTicks == 56) {
            this.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_STUN_END.get(), 2.25f, this.m_6100_());
        }
        if (this.stunnedTicks == this.stunnedAnimationActionPoint) {
            this.shockwave();
        }
        if (this.stunnedTicks == this.stunnedLength - 20 || this.f_20919_ == 1) {
            for (PartEntity<?> shield : this.getParts()) {
                for (int i = 0; i < 20; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypeInit.BROKEN_MUTANT_BLAZE_SHIELD.get(), shield.m_20208_(0.75), shield.m_20187_(), shield.m_20262_(0.75), 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.stunnedTicks == this.stunnedLength - 135) {
            for (int i = 0; i < this.shieldRegenerateTicks.length; ++i) {
                this.shieldRegenerateTicks[i] = 20;
            }
        }
        if (!this.f_19853_.f_46443_ && this.shouldHeat() && ((Boolean)MutantBlazeCommonConfig.heat_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue() && this.f_19796_.m_188503_(((Integer)MutantBlazeCommonConfig.heat_griefing_chance.get()).intValue()) == 0 && this.f_19853_.m_8055_(pos = new BlockPos((Vec3i)this.m_20183_().m_7637_(-this.heatRange() + (double)this.f_19796_.m_188503_(Mth.m_14107_((double)(this.heatRange() * 2.0))), -this.heatRangeY() + (double)this.f_19796_.m_188503_(Mth.m_14107_((double)(this.heatRangeY() * 2.0))), -this.heatRange() + (double)this.f_19796_.m_188503_(Mth.m_14107_((double)(this.heatRange() * 2.0)))))).m_60795_()) {
            this.f_19853_.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)pos));
        }
        if (this.shouldCrouchAt(this.m_20183_()) || this.m_5830_()) {
            this.m_20124_(Pose.CROUCHING);
        } else {
            this.m_20124_(Pose.STANDING);
        }
        if (this.isInFluidType()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_76178_()) {
                this.f_19861_ = true;
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.05, 0.0));
            }
        }
        if (((Boolean)MutantBlazeClientConfig.show_health_bar.get()).booleanValue() || ((Boolean)MutantMoreGroupedOptionsClientConfig.show_health_bars_on.get()).booleanValue()) {
            if (this.m_5448_() != null && this.m_6084_()) {
                if (this.m_5448_() instanceof ServerPlayer) {
                    this.bossEvent.m_6543_((ServerPlayer)this.m_5448_());
                }
                for (ServerPlayer player : this.f_19853_.m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(20.0), MiscUtils.ALIVE)) {
                    this.bossEvent.m_6543_(player);
                }
            } else if (this.m_5448_() == null || !this.m_6084_()) {
                for (ServerPlayer player : this.f_19853_.m_6443_(ServerPlayer.class, this.m_20191_().m_82400_(75.0), MiscUtils.ALIVE)) {
                    this.bossEvent.m_6539_(player);
                }
            }
        }
        Vec3 velocity = this.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (!this.f_19853_.f_46443_ && groundSpeed <= 0.1f && this.noveltyAnimationTick <= 0 && this.f_19796_.m_188503_(400) == 0 && (this.m_5448_() == null || this.m_5448_().m_21224_() || this.m_5448_().m_213877_())) {
            this.noveltyAnimationTick = this.noveltyAnimationLength;
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
    }

    @Override
    public double heatRange() {
        return this.shouldHeat() ? (Double)MutantBlazeCommonConfig.heat_range.get() : 0.0;
    }

    @Override
    public double heatRangeY() {
        return this.shouldHeat() ? (Double)MutantBlazeCommonConfig.heat_range_y.get() : 0.0;
    }

    @Override
    public double heatSpeed() {
        return (Double)MutantBlazeCommonConfig.heat_speed.get();
    }

    public boolean shouldHeat() {
        return this.f_20919_ <= 0 && this.stunnedTicks <= this.stunnedAnimationActionPoint + 30;
    }

    @Override
    public boolean canHeat(LivingEntity heatTarget) {
        if (heatTarget.m_6095_().m_204039_(TagInit.EntityTypes.CANT_BE_HEATED)) {
            return false;
        }
        if (heatTarget.m_6095_().m_204039_(TagInit.EntityTypes.MUTANT_BLAZE_CANT_HEAT)) {
            return false;
        }
        if (heatTarget.m_5825_() && !((Boolean)MutantBlazeCommonConfig.heats_fire_immune_mobs.get()).booleanValue()) {
            return false;
        }
        if (this.m_5647_() != null && heatTarget.m_5647_() != null && (this.m_5647_() == heatTarget.m_5647_() || this.m_5647_().m_83536_(heatTarget.m_5647_()))) {
            return false;
        }
        if (heatTarget.m_5833_()) {
            return false;
        }
        return !(heatTarget instanceof Player) || !((Player)heatTarget).m_7500_();
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 11) {
            this.introAnimationTick = this.introAnimationLength;
        } else if (p_28844_ == 5) {
            this.noveltyAnimationTick = this.noveltyAnimationLength;
        } else if (p_28844_ == 4) {
            this.shootAnimationTick = this.shootAnimationLength;
        } else if (p_28844_ == 12) {
            this.stunnedTicks = this.stunnedLength;
        } else if (p_28844_ == 13) {
            this.rodShotAnimationTick = this.rodShotAnimationLength;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public boolean m_203441_(FluidState p_204067_) {
        return p_204067_ != null && !p_204067_.m_76178_();
    }

    public void m_6593_(@Nullable Component p_31476_) {
        super.m_6593_(p_31476_);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
            if (this.destroyBlocksTick == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                int j1 = Mth.m_14107_((double)this.m_20186_());
                int i2 = Mth.m_14107_((double)this.m_20185_());
                int j2 = Mth.m_14107_((double)this.m_20189_());
                boolean flag = false;
                AABB aabb = this.m_20191_().m_82377_(0.5, 0.0, 0.5);
                for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                    BlockState blockstate = this.f_19853_.m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    if (blockstate.m_204336_(TagInit.Blocks.UNBREAKABLE)) continue;
                    flag = this.f_19853_.m_46953_(blockpos, (Boolean)MutantBlazeCommonConfig.hurt_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false, (Entity)this) || flag;
                }
                if (flag) {
                    this.f_19853_.m_5898_((Player)null, 1022, this.m_20183_(), 0);
                }
            }
        }
        super.m_8024_();
    }

    public void m_6452_(ServerPlayer p_31488_) {
        super.m_6452_(p_31488_);
        this.bossEvent.m_6539_(p_31488_);
    }

    public boolean m_142582_(Entity p_147185_) {
        if (p_147185_.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 vec31 = new Vec3(p_147185_.m_20185_(), p_147185_.m_20186_() + 1.0, p_147185_.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public void m_20234_(int p_145769_1_) {
        super.m_20234_(p_145769_1_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_145769_1_ + i + 1);
        }
    }

    class RemainStationaryGoal
    extends Goal {
        public RemainStationaryGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return MutantBlaze.this.shouldBeStationary();
        }
    }

    class FlyStrafeMovementGoal
    extends Goal {
        public MutantBlaze mob;
        @Nullable
        public LivingEntity target;
        public int goalRunningTime;
        public int nextUseTime;
        public double sidewaysMotionSpeed = 0.0;
        public double maxSidewaysMotionSpeed = (Double)MutantBlazeCommonConfig.flying_strafe_speed.get();
        public double sidewaysMotionSpeedChangeAmount = (Double)MutantBlazeCommonConfig.flying_strafe_direction_change_speed.get();
        public boolean desiredSidewaysMotionDirection = false;
        public Vec3 groundPos = null;
        public boolean stopUsing;

        public FlyStrafeMovementGoal(MutantBlaze mob) {
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return !this.mob.shouldBeStationary() && this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && (this.mob.m_142582_((Entity)this.target) && this.mob.f_19797_ >= this.nextUseTime && this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantBlazeCommonConfig.flight_health_threshold.get()).floatValue() / 100.0f) || this.mob.m_20186_() <= this.target.m_20186_() - (Double)MutantBlazeCommonConfig.flight_below_target_start_distance.get());
        }

        public boolean m_8045_() {
            return !this.mob.shouldBeStationary() && this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.stopUsing;
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_START_FLYING.get(), 2.0f, this.mob.m_6100_());
            this.stopUsing = false;
            this.groundPos = null;
            this.goalRunningTime = 0;
        }

        public void m_8037_() {
            Vec3 targetPosAway;
            this.target = this.mob.m_5448_();
            ++this.goalRunningTime;
            this.mob.m_21573_().m_26573_();
            if (this.goalRunningTime >= (Integer)MutantBlazeCommonConfig.stop_flying_time.get() && this.groundPos == null && (targetPosAway = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)((Integer)MutantBlazeCommonConfig.flight_land_search_range_horizontal.get()), (int)((Integer)MutantBlazeCommonConfig.flight_land_search_range_vertical.get()), (Vec3)(this.target != null ? this.target.m_20182_() : this.mob.m_20182_()))) != null && !this.mob.shouldCrouchAt(new BlockPos(targetPosAway.f_82479_, targetPosAway.f_82480_, targetPosAway.f_82481_))) {
                this.groundPos = targetPosAway;
            }
            if (this.groundPos != null) {
                this.mob.setFlying(true);
                if (this.target != null) {
                    this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
                }
                this.mob.m_20334_(0.0, 0.0, 0.0);
                double x = this.groundPos.f_82479_ - this.mob.m_20185_();
                double y = this.groundPos.f_82480_ - this.mob.m_20186_();
                double z = this.groundPos.f_82481_ - this.mob.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                this.mob.m_20256_(this.mob.m_20184_().m_82520_(x / d * (double)0.2f, y / d * (double)0.2f, z / d * (double)0.2f).m_82490_(1.0));
                boolean blocksBelow = false;
                for (int i = 0; i < 5; ++i) {
                    if (this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_6625_(i)).m_60795_()) continue;
                    blocksBelow = true;
                    break;
                }
                if (blocksBelow) {
                    this.stopUsing = true;
                } else if (this.mob.m_20186_() < this.groundPos.f_82480_ + (Double)MutantBlazeCommonConfig.flight_height.get() || !this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7495_()).m_60795_()) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, ((Double)MutantBlazeCommonConfig.flying_vertical_speed.get()).doubleValue(), 0.0));
                }
            } else if (this.target != null) {
                this.mob.setFlying(true);
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.target.m_20182_());
                if (this.sidewaysMotionSpeed <= -this.maxSidewaysMotionSpeed || this.sidewaysMotionSpeed >= this.maxSidewaysMotionSpeed) {
                    boolean bl = this.desiredSidewaysMotionDirection = !this.desiredSidewaysMotionDirection;
                }
                this.sidewaysMotionSpeed = this.desiredSidewaysMotionDirection ? (this.sidewaysMotionSpeed += this.sidewaysMotionSpeedChangeAmount) : (this.sidewaysMotionSpeed -= this.sidewaysMotionSpeedChangeAmount);
                Vec3 sidewaysMotion = PositionUtils.getOffsetMotion((Entity)this.mob, this.sidewaysMotionSpeed, 0.0, 0.0, this.mob.f_20883_);
                if (this.mob.m_20186_() < this.target.m_20186_() + (Double)MutantBlazeCommonConfig.flight_height.get() || !this.mob.f_19853_.m_8055_(this.mob.m_20183_().m_7495_()).m_60795_()) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, ((Double)MutantBlazeCommonConfig.flying_vertical_speed.get()).doubleValue(), 0.0));
                }
                this.mob.m_20334_(0.0, this.mob.m_20184_().f_82480_, 0.0);
                if ((double)this.mob.m_20270_((Entity)this.target) <= (Double)MutantBlazeCommonConfig.flight_avoid_target_max_distance.get()) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(PositionUtils.getOffsetMotion((Entity)this.mob, 0.0, 0.0, -((Double)MutantBlazeCommonConfig.flying_movement_speed.get()).doubleValue(), this.mob.f_20883_).m_82549_(sidewaysMotion)));
                } else if ((double)this.mob.m_20270_((Entity)this.target) >= (Double)MutantBlazeCommonConfig.flight_approach_target_min_distance.get()) {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(PositionUtils.getOffsetMotion((Entity)this.mob, 0.0, 0.0, (Double)MutantBlazeCommonConfig.flying_movement_speed.get(), this.mob.f_20883_).m_82549_(sidewaysMotion)));
                } else {
                    this.mob.m_20256_(this.mob.m_20184_().m_82549_(sidewaysMotion));
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.stopUsing = false;
            this.nextUseTime = this.mob.f_19797_ + (Integer)MutantBlazeCommonConfig.flight_cooldown.get();
            this.mob.setFlying(false);
        }
    }

    public class LeaveCorridorsGoal
    extends Goal {
        protected final MutantBlaze mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;

        public LeaveCorridorsGoal(MutantBlaze p_25221_, double p_25222_) {
            this.mob = p_25221_;
            this.speedModifier = p_25222_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.mob.m_6047_() ? false : this.setWantedPos();
        }

        protected boolean setWantedPos() {
            Vec3 vec3 = this.getHidePos();
            if (vec3 == null) {
                return false;
            }
            this.wantedX = vec3.f_82479_;
            this.wantedY = vec3.f_82480_;
            this.wantedZ = vec3.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            return !this.mob.m_21573_().m_26571_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        protected Vec3 getHidePos() {
            RandomSource randomsource = this.mob.m_217043_();
            BlockPos blockpos = this.mob.m_20183_();
            for (int i = 0; i < 20; ++i) {
                BlockPos blockpos1 = blockpos.m_7918_(randomsource.m_188503_(80) - 40, randomsource.m_188503_(6) - 3, randomsource.m_188503_(80) - 40);
                if (this.mob.shouldCrouchAt(blockpos1) || !(this.mob.m_21692_(blockpos1) < 0.0f)) continue;
                return Vec3.m_82539_((Vec3i)blockpos1);
            }
            return null;
        }
    }

    class ShootAttackGoal
    extends Goal {
        public MutantBlaze mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;

        public ShootAttackGoal(MutantBlaze mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.f_19797_ >= this.nextUseTime && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_PREPARE_SHOOT.get(), 2.0f, 1.0f);
            this.mob.shootAnimationTick = this.mob.shootAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)4);
        }

        public void m_8037_() {
            Vec3 particlePos;
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.mob.shootAnimationTick == this.mob.shootAnimationLength - 15) {
                particlePos = PositionUtils.getOffsetPos((Entity)this.mob, 0.0, 2.5, -1.0, this.mob.f_20883_);
                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)new EntityTrackingParticleOption("mutantmore:mutant_blaze_charge_shot", this.mob.m_19879_(), 0.0, 2.5, -1.0), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_FLARE.get(), 2.0f, this.mob.m_6100_());
            }
            if (this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantBlazeCommonConfig.shoot_extra_fireballs_health_threshold_1.get()).floatValue() / 100.0f) && (this.mob.shootAnimationTick == this.mob.shootAnimationLength - 20 || this.mob.shootAnimationTick == this.mob.shootAnimationLength - 25)) {
                particlePos = PositionUtils.getOffsetPos((Entity)this.mob, 0.0, 2.5, -1.0, this.mob.f_20883_);
                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)new EntityTrackingParticleOption("mutantmore:mutant_blaze_charge_shot", this.mob.m_19879_(), 0.0, 2.5, -1.0), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_FLARE.get(), 2.0f, this.mob.m_6100_());
            }
            if (this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantBlazeCommonConfig.shoot_extra_fireballs_health_threshold_2.get()).floatValue() / 100.0f) && (this.mob.shootAnimationTick == this.mob.shootAnimationLength - 30 || this.mob.shootAnimationTick == this.mob.shootAnimationLength - 35)) {
                particlePos = PositionUtils.getOffsetPos((Entity)this.mob, 0.0, 2.5, -1.0, this.mob.f_20883_);
                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)new EntityTrackingParticleOption("mutantmore:mutant_blaze_charge_shot", this.mob.m_19879_(), 0.0, 2.5, -1.0), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_FLARE.get(), 2.0f, this.mob.m_6100_());
            }
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
                double d1 = this.target.m_20185_() - this.mob.m_20185_();
                double d2 = this.target.m_20227_(0.5) - this.mob.m_20227_(0.5);
                double d3 = this.target.m_20189_() - this.mob.m_20189_();
                if (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint) {
                    this.mob.shootMutantBlazeFireball(d1, d2, d3, false);
                }
                if (this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantBlazeCommonConfig.shoot_extra_fireballs_health_threshold_1.get()).floatValue() / 100.0f) && (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 6 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 12)) {
                    this.mob.shootMutantBlazeFireball(d1, d2, d3, false);
                }
                if (this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantBlazeCommonConfig.shoot_extra_fireballs_health_threshold_2.get()).floatValue() / 100.0f) && (this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 18 || this.mob.shootAnimationTick == this.mob.shootAnimationActionPoint - 24)) {
                    this.mob.shootMutantBlazeFireball(d1, d2, d3, false);
                }
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (Integer)MutantBlazeCommonConfig.shoot_cooldown.get();
        }

        public boolean animationsUseable() {
            return this.mob.shootAnimationTick <= 0;
        }
    }

    class RodShotAttackGoal
    extends Goal {
        private final TargetingConditions rodlingCountTargeting = TargetingConditions.m_148353_().m_26883_(50.0).m_148355_().m_26893_().m_26888_(entity -> entity instanceof Rodling && !((Rodling)((Object)entity)).m_21824_());
        public MutantBlaze mob;
        @Nullable
        public LivingEntity target;
        public int nextUseTime;
        public int currentRod = 0;
        public List<MutantBlazeRodProjectile> totalProjectiles = Lists.newArrayList();
        public List<MutantBlazeRodProjectile> nonRodlingProjectiles = Lists.newArrayList();

        public RodShotAttackGoal(MutantBlaze mob) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
            this.mob = mob;
            this.target = mob.m_5448_();
        }

        public boolean m_6767_() {
            return this.mob.shouldBeStationary();
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && this.mob.m_142582_((Entity)this.target) && this.mob.f_19797_ >= this.nextUseTime && this.animationsUseable();
        }

        public boolean m_8045_() {
            return this.target != null && !this.target.m_213877_() && !this.target.m_21224_() && !this.animationsUseable();
        }

        public void m_8056_() {
            this.currentRod = 0;
            this.totalProjectiles.clear();
            this.nonRodlingProjectiles.clear();
            this.mob.m_5496_((SoundEvent)SoundEventInit.MUTANT_BLAZE_RODSHOT.get(), 2.0f, 1.0f);
            this.mob.rodShotAnimationTick = this.mob.rodShotAnimationLength;
            this.mob.f_19853_.m_7605_((Entity)this.mob, (byte)13);
            for (int i = 0; i < 13; ++i) {
                MutantBlazeRodProjectile rod = new MutantBlazeRodProjectile(this.mob.f_19853_, (LivingEntity)this.mob);
                this.totalProjectiles.add(rod);
                this.nonRodlingProjectiles.add(rod);
            }
            int nearbyRodlings = this.mob.f_19853_.m_45971_(Rodling.class, this.rodlingCountTargeting, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(50.0)).size();
            if (nearbyRodlings <= (Integer)MutantBlazeCommonConfig.rodling_shot_max_nearby_rodlings.get()) {
                for (int i = 0; i < (Integer)MutantBlazeCommonConfig.rodling_shot_rodling_amount.get(); ++i) {
                    MutantBlazeRodProjectile rod = this.nonRodlingProjectiles.get(this.mob.f_19796_.m_188503_(this.nonRodlingProjectiles.size()));
                    rod.setIsRodling(true);
                    if (this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantBlazeCommonConfig.rodling_shot_armoured_rodlings_health_threshold.get()).floatValue() / 100.0f) && MiscUtils.randomPercent((Integer)MutantBlazeCommonConfig.rodling_shot_shoot_armoured_rodlings_chance.get())) {
                        rod.setHasArmour(true);
                    }
                    if (this.mob.m_21223_() <= this.mob.m_21233_() * (((Integer)MutantBlazeCommonConfig.rodling_shot_shielded_rodlings_health_threshold.get()).floatValue() / 100.0f) && MiscUtils.randomPercent((Integer)MutantBlazeCommonConfig.rodling_shot_shoot_shielded_rodlings_chance.get())) {
                        rod.setHasShields(true);
                    }
                    this.nonRodlingProjectiles.remove((Object)rod);
                }
            }
        }

        public void m_8037_() {
            this.target = this.mob.m_5448_();
            this.mob.m_21573_().m_26573_();
            if (this.target != null) {
                this.mob.m_21563_().m_148051_((Entity)this.target);
                if (this.mob.rodShotAnimationTick <= this.mob.rodShotAnimationActionStartPoint && this.mob.rodShotAnimationTick >= this.mob.rodShotAnimationActionEndPoint) {
                    Vec3 pos = PositionUtils.getOffsetPos((Entity)this.mob, 0.0, 5.1, 0.5, this.mob.f_20883_);
                    double d1 = this.target.m_20185_() - pos.f_82479_;
                    double d2 = this.target.m_20188_() - pos.f_82480_;
                    double d3 = this.target.m_20189_() - pos.f_82481_;
                    MutantBlazeRodProjectile rod = this.totalProjectiles.get(Mth.m_14045_((int)this.currentRod, (int)0, (int)(this.totalProjectiles.size() - 1)));
                    rod.damage = ((Double)MutantBlazeCommonConfig.rod_damage.get()).floatValue();
                    rod.fireLength = (Integer)MutantBlazeCommonConfig.rod_set_mob_on_fire_length.get();
                    rod.ignoresInvulTime = (Boolean)MutantBlazeCommonConfig.ignores_invulnerability_time.get();
                    rod.griefing = (Boolean)MutantBlazeCommonConfig.rod_griefing.get() != false && (Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get() == false;
                    rod.griefingDropsBlocks = (Boolean)MutantBlazeCommonConfig.rod_griefing_drops_blocks.get() != false || (Boolean)MutantMoreGroupedOptionsCommonConfig.griefing_drops_blocks_on.get() != false;
                    rod.fireGriefing = (Boolean)MutantBlazeCommonConfig.rod_fire.get();
                    rod.m_20219_(pos);
                    rod.m_6686_(d1, d2, d3, 1.8f, 5.0f);
                    this.mob.f_19853_.m_7967_((Entity)rod);
                    ++this.currentRod;
                }
            }
        }

        public void m_8041_() {
            this.nextUseTime = this.mob.f_19797_ + (Integer)MutantBlazeCommonConfig.rod_shot_cooldown.get();
        }

        public boolean animationsUseable() {
            return this.mob.rodShotAnimationTick <= 0;
        }
    }

    static class MutantBlazeNavigation
    extends GroundPathNavigation {
        public MutantBlazeNavigation(Mob p_33379_, Level p_33380_) {
            super(p_33379_, p_33380_);
        }

        protected PathFinder m_5532_(int p_33382_) {
            this.f_26508_ = new MutantBlazeNodeEvaluator();
            return new PathFinder(this.f_26508_, p_33382_);
        }

        protected void m_6804_() {
            super.m_6804_();
            if (!this.f_26494_.m_6047_() && ((MutantBlaze)this.f_26494_).shouldCrouchAt(new BlockPos(this.f_26494_.m_20185_(), this.f_26494_.m_20186_() + 0.5, this.f_26494_.m_20189_()))) {
                return;
            }
            for (int i = 0; i < this.f_26496_.m_77398_(); ++i) {
                Node node = this.f_26496_.m_77375_(i);
                if (this.f_26494_.m_6047_() || !((MutantBlaze)this.f_26494_).shouldCrouchAt(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_))) continue;
                this.f_26496_.m_77388_(i);
                return;
            }
        }
    }

    static class MutantBlazeNodeEvaluator
    extends WalkNodeEvaluator {
        MutantBlazeNodeEvaluator() {
        }

        public void m_6028_(PathNavigationRegion p_77620_, Mob p_77621_) {
            super.m_6028_(p_77620_, p_77621_);
            this.f_77315_ = Mth.m_14143_((float)(p_77621_.m_20205_() + 1.0f));
            this.f_77316_ = Mth.m_14143_((float)MutantBlaze.crouchingDimensions.f_20378_);
            this.f_77317_ = Mth.m_14143_((float)(p_77621_.m_20205_() + 1.0f));
        }

        public BlockPathTypes m_8086_(BlockGetter p_77576_, int p_77577_, int p_77578_, int p_77579_) {
            if (p_77576_.m_8055_(new BlockPos(p_77577_, p_77578_, p_77579_)).m_204336_(TagInit.Blocks.MUTANT_BLAZE_WALKS_THROUGH) && ((Boolean)MutantBlazeCommonConfig.walk_griefing.get()).booleanValue() && !((Boolean)MutantMoreGroupedOptionsCommonConfig.mob_griefing_off.get()).booleanValue()) {
                return BlockPathTypes.OPEN;
            }
            return MutantBlazeNodeEvaluator.m_77604_((BlockGetter)p_77576_, (BlockPos.MutableBlockPos)new BlockPos.MutableBlockPos(p_77577_, p_77578_, p_77579_));
        }
    }
}

